/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils;

import filenet.vw.base.VWDebug;
import filenet.vw.base.VWLogger;
import filenet.vw.idm.panagon.VWPanagonFactoryProperties;
import filenet.vw.idm.toolkit.IVWIDMFactoryProperties;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.IVWAppLauncher;
import filenet.vw.toolkit.utils.IVWLaunchableApp;
import filenet.vw.toolkit.utils.VWChildAppManager;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.jar.JarEntry;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.UIManager;
import netscape.javascript.JSObject;

public abstract class VWBaseAppLauncherApplet
extends JApplet
implements IVWAppLauncher {
    protected VWSessionInfo m_sessionInfo = null;
    private Object m_keepAlive = null;
    private VWChildAppManager m_childAppManager = null;
    private boolean m_bInitialized = false;

    public void init() {
        try {
            VWDebug.init(VWLogger.ERROR);
            this.getRootPane().putClientProperty("defeatSystemEventQueueCheck", Boolean.TRUE);
            this.m_sessionInfo = new VWSessionInfo(this, this);
            this.m_bInitialized = true;
            VWHelp.init(this);
            if (this.m_sessionInfo.isIMSuiteWebApp()) {
                this.checkExtensionFile("ntutil.jar", "/lib/ntutil.jar", System.getProperty("java.ext.dirs"));
                this.checkExtensionFile("vwntutil.dll", "/lib/vwntutil.dll", System.getProperty("java.home") + "/bin");
            }
            this.createKeepAlive();
            if (System.getProperty("java.vm.version").startsWith("1.4.2")) {
                UIManager.getDefaults().put("MenuItemUI", "filenet.vw.toolkit.utils.VWWorkaroundMenuItemUI");
                UIManager.getDefaults().put("ClassLoader", this.m_sessionInfo.getExternalClassLoader());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void closeWindow() {
        try {
            if (this.isActive()) {
                try {
                    this.closeWindow(VWResource.s_appletClosedMsg, VWResource.s_closeWindowMsg);
                    Class.forName("netscape.javascript.JSObject");
                    JSObject window = JSObject.getWindow((Applet)this);
                    window.call("CloseWindow", null);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void closeWindow(String infoMessage, String closingMessage) {
        try {
            this.logoff();
            if (this.isActive()) {
                Container contentPane;
                if (infoMessage == null || infoMessage.length() == 0) {
                    infoMessage = VWResource.s_appletClosedMsg;
                }
                if (closingMessage == null || closingMessage.length() == 0) {
                    closingMessage = VWResource.s_closeWindowMsg;
                }
                JPanel panel = new JPanel(new GridBagLayout());
                panel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
                GridBagConstraints gbCons = new GridBagConstraints();
                gbCons.anchor = 10;
                gbCons.gridx = 0;
                gbCons.gridy = 0;
                gbCons.gridwidth = 0;
                gbCons.gridheight = 1;
                gbCons.weightx = 0.0;
                gbCons.weighty = 0.0;
                gbCons.fill = 1;
                gbCons.insets = new Insets(4, 4, 4, 4);
                gbCons.ipadx = 0;
                gbCons.ipady = 0;
                panel.add((Component)new JLabel(infoMessage), gbCons);
                ++gbCons.gridy;
                gbCons.fill = 2;
                panel.add((Component)new JLabel(closingMessage), gbCons);
                JMenuBar menuBar = this.getRootPane().getJMenuBar();
                if (menuBar != null) {
                    menuBar.removeAll();
                    menuBar.invalidate();
                    menuBar.validate();
                    menuBar.repaint();
                }
                if ((contentPane = this.getContentPane()) != null) {
                    contentPane.removeAll();
                    contentPane.setLayout(new BorderLayout());
                    contentPane.add((Component)panel, "Center");
                    contentPane.invalidate();
                    contentPane.validate();
                    contentPane.repaint();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void destroy() {
        try {
            this.logoff();
            if (this.m_bInitialized) {
                VWHelp.cleanUp(this);
                VWIDMBaseFactory.release();
                this.m_bInitialized = false;
                if (this.m_keepAlive != null) {
                    this.m_keepAlive.getClass().getMethod("destroy", null).invoke(this.m_keepAlive, null);
                    this.m_keepAlive = null;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public String getBaseURL() {
        try {
            String baseURL = this.getParameter("baseURL");
            if (baseURL != null) {
                return baseURL;
            }
            if (this.m_sessionInfo != null && this.m_sessionInfo.isWebWorkFloWebApp()) {
                String documentBase = this.getDocumentBase().toString().toLowerCase();
                int nIndex = documentBase.lastIndexOf("/redist/");
                if (nIndex == -1) {
                    nIndex = documentBase.lastIndexOf("/application/");
                }
                if (nIndex == -1) {
                    return documentBase;
                }
                return documentBase.substring(0, nIndex + 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public VWSessionInfo getSessionInfo() {
        return this.m_sessionInfo;
    }

    public boolean logoff() {
        boolean bAppsClosed = true;
        try {
            if (this.m_childAppManager != null && this.isActive()) {
                bAppsClosed = this.m_childAppManager.closeChildApplications();
            }
            if (bAppsClosed) {
                this.simpleLogoff();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return bAppsClosed;
    }

    public void simpleLogoff() {
        try {
            if (this.m_sessionInfo != null) {
                this.m_sessionInfo.logoff();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void registerApplication(IVWLaunchableApp childApp) {
        try {
            if (this.m_childAppManager == null) {
                this.m_childAppManager = new VWChildAppManager(this);
            }
            this.m_childAppManager.registerApplication(childApp);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean hasChildClass(String className) {
        try {
            if (this.m_childAppManager == null) {
                return false;
            }
            return this.m_childAppManager.hasChildClass(className);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
    }

    public boolean bringChildAppToFront(String className) {
        try {
            if (this.m_childAppManager == null) {
                return false;
            }
            return this.m_childAppManager.bringChildAppToFront(className);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
    }

    public void windowClosing(WindowEvent event) {
        this.childWindowClosed();
    }

    protected void abort() {
        this.closeWindow();
    }

    protected void childWindowClosed() {
    }

    protected boolean hasChildren() {
        if (this.m_childAppManager != null) {
            return this.m_childAppManager.hasChildren();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void checkExtensionFile(String fileName, String resourceName, String extDir) {
        block30: {
            File theFile = null;
            boolean bDownloadIt = true;
            InputStream jarStream = null;
            BufferedInputStream inStream = null;
            FilterOutputStream outStream = null;
            theFile = new File(extDir, fileName);
            if (theFile != null && theFile.exists()) {
                bDownloadIt = false;
                URL resourceURL = this.getClass().getResource(resourceName);
                if (resourceURL != null) {
                    JarURLConnection jarConnection = (JarURLConnection)resourceURL.openConnection();
                    JarEntry jarEntry = jarConnection.getJarEntry();
                    if (jarEntry != null) {
                        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
                        long jarLastModified = theFile.lastModified();
                        long resourceLastModified = jarEntry.getTime();
                        System.out.println("Jar resource " + jarEntry.getName() + ", lastModified=" + dateFormatter.format(new Date(resourceLastModified)));
                        System.out.println("File " + theFile.getAbsolutePath() + " - lastModified = " + dateFormatter.format(new Date(jarLastModified)));
                        bDownloadIt = jarLastModified < resourceLastModified;
                    }
                    jarEntry = null;
                    jarConnection = null;
                }
                resourceURL = null;
            }
            if (bDownloadIt) {
                jarStream = this.getClass().getResourceAsStream(resourceName);
                if (jarStream != null) {
                    inStream = new BufferedInputStream(jarStream);
                    int size = inStream.available();
                    if (size > 0) {
                        System.out.println("Writing " + theFile.getAbsolutePath() + " ... " + size + " bytes.");
                        try {
                            outStream = new BufferedOutputStream(new FileOutputStream(theFile));
                            for (int i = 0; i < size; ++i) {
                                ((BufferedOutputStream)outStream).write(inStream.read());
                            }
                            ((BufferedOutputStream)outStream).flush();
                        }
                        catch (Throwable throwable) {
                            Object var18_21 = null;
                            if (outStream != null) {
                                outStream.close();
                            }
                            outStream = null;
                            throw throwable;
                        }
                    }
                    System.out.println("Nothing to write");
                    inStream.close();
                    inStream = null;
                }
                jarStream = null;
            }
            theFile = null;
            Object var20_23 = null;
            try {
                if (outStream != null) {
                    outStream.close();
                    outStream = null;
                    if (theFile != null) {
                        theFile.delete();
                    }
                }
                if (inStream != null) {
                    inStream.close();
                    inStream = null;
                }
                jarStream = null;
            }
            catch (Throwable t2) {}
            break block30;
            {
                catch (Throwable t) {
                    t.printStackTrace();
                    Object var20_24 = null;
                    try {
                        if (outStream != null) {
                            outStream.close();
                            outStream = null;
                            if (theFile != null) {
                                theFile.delete();
                            }
                        }
                        if (inStream != null) {
                            inStream.close();
                            inStream = null;
                        }
                        jarStream = null;
                    }
                    catch (Throwable t2) {}
                }
            }
            catch (Throwable throwable) {
                Object var20_25 = null;
                try {
                    if (outStream != null) {
                        outStream.close();
                        outStream = null;
                        if (theFile != null) {
                            theFile.delete();
                        }
                    }
                    if (inStream != null) {
                        inStream.close();
                        inStream = null;
                    }
                    jarStream = null;
                }
                catch (Throwable t2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void createKeepAlive() {
        try {
            if (this.m_sessionInfo == null) {
                return;
            }
            long lInterval = 10L;
            try {
                String keepAliveInterval = this.getParameter("keepAlive");
                if (keepAliveInterval != null && keepAliveInterval.length() > 0) {
                    lInterval = Long.parseLong(keepAliveInterval);
                }
            }
            catch (NumberFormatException ex) {
                VWDebug.logException(ex);
            }
            Class<?> keepAliveClass = null;
            String webServerURL = null;
            if (this.m_sessionInfo.isWorkPlaceWebApp()) {
                keepAliveClass = Class.forName("com.filenet.wcm.toolkit.client.util.WcmKeepAlive");
                webServerURL = this.getParameter("keepAliveURL");
                if (webServerURL == null) {
                    webServerURL = this.getParameter("webServerURL");
                }
            } else if (this.m_sessionInfo.isIMSuiteWebApp()) {
                keepAliveClass = Class.forName("filenet.vw.toolkit.utils.VWKeepAlive");
                IVWIDMFactoryProperties factoryProperties = VWIDMBaseFactory.instance().getProperties();
                if (factoryProperties != null && factoryProperties instanceof VWPanagonFactoryProperties) {
                    VWPanagonFactoryProperties panagonProperties = (VWPanagonFactoryProperties)factoryProperties;
                    String ASPCodeBase = panagonProperties.getBaseURL();
                    if (ASPCodeBase == null) {
                        return;
                    }
                    webServerURL = ASPCodeBase + panagonProperties.getSessDir() + panagonProperties.getPageToRetrieveTokens() + "?VW=1";
                }
            } else if (this.m_sessionInfo.isCustomWebApp()) {
                keepAliveClass = Class.forName(this.getParameter("keepAliveClassName"));
                webServerURL = this.getParameter("webServerURL");
            }
            if (keepAliveClass != null && webServerURL != null) {
                this.m_keepAlive = keepAliveClass.getDeclaredConstructor(String.class, Long.TYPE).newInstance(webServerURL, lInterval);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

